--SELECT * FROM V_EST_NF_SAI_IT_PIS_COFINS
ALTER VIEW [dbo].[V_EST_NF_SAI_IT_PIS_COFINS] AS
SELECT
	EST_NF_SAI_IT.CD_EMP,
	EST_NF_SAI_IT.CD_FILIAL,
	EST_NF_SAI_IT.CD_NF,
	CASE WHEN EST_NF_SAI_IT.PIS_COFINS = 1 THEN 
		SUM(EST_NF_SAI_IT.VLR_TOT_IT)
	ELSE 
		0
	END AS VLR_BASE_PIS_COFINS,
	CASE WHEN ISNULL(SUM(EST_NF_SAI_IT.VLR_BASE_SUBS), 0) = 0	THEN
		ROUND(SUM(EST_NF_SAI_IT.VLR_ICMS_IT),2)	
	ELSE 
	0
	END AS VLR_ICMS_ITENS
FROM   
	EST_NF_SAI_IT INNER JOIN EST_PROD ON 
	EST_NF_SAI_IT.CD_EMP = EST_PROD.CD_EMP AND 
	EST_NF_SAI_IT.CD_PROD = EST_PROD.CD_PROD
GROUP  BY 
	EST_NF_SAI_IT.CD_EMP,
	EST_NF_SAI_IT.CD_FILIAL,
	EST_NF_SAI_IT.CD_NF,
	EST_NF_SAI_IT.PIS_COFINS